require "BuildingObjects/ISBuildingObject"

HCBrickPillar = ISBuildingObject:derive("HCBrickPillar");

function HCBrickPillar:create(x, y, z, north, sprite)
	local cell = getWorld():getCell();
	local eHP = getSpecificPlayer(self.player):getPerkLevel(Perks.Woodwork)*2000;
	local objHP = 4000 + eHP;
	if getSpecificPlayer(self.player):HasTrait("Handy") then
		objHP = objHP + 100;
	end
	self.sq = cell:getGridSquare(x, y, z);
	self.javaObject = IsoThumpable.new(cell, self.sq, sprite, north, self);
	buildUtil.setInfo(self.javaObject, self);
	local self2 = self;
	self2.modData["need:Hydrocraft.HCBrickpillar"] = "1";
	buildUtil.consumeMaterial(self2);
	self2 = nil;
	self.javaObject:setMaxHealth(objHP);
	self.javaObject:setBreakSound("breakdoor");
	self.sq:AddSpecialObject(self.javaObject);
	self.sq:RecalcAllWithNeighbours(true);
	self.javaObject:transmitCompleteItemToServer();
end

function HCBrickPillar:new(sprite, player)
	local o = {};
	setmetatable(o, self);
	self.__index = self;
	o:init();
	o:setSprite(sprite);
	o:setNorthSprite(sprite);
	o.name = "Brick Pillar";
	o.canBarricade = false;
	o.dismantable = false;
	o.blockAllTheSquare = true;
	o.canBeAlwaysPlaced = false;
	o.noNeedHammer = true;
	o.character = player;
	return o;
end

function HCBrickPillar.onDestroy(thump, player)
	if thump:getName() ~= "Brick Pillar" then return end
	for x=0, 14+ZombRand(11) do
		thump:getSquare():AddWorldInventoryItem("Hydrocraft.HCRedbrick", 0.0, 0.0, 0.0);
	end
	thump:getSquare():transmitRemoveItemFromSquare(thump);
	thump:getSquare():RemoveTileObject(thump);
end

function HCBrickPillar:render(x, y, z, square)
	ISBuildingObject.render(self, x, y, z, square);
end

Events.OnDestroyIsoThumpable.Add(HCBrickPillar.onDestroy);